# Kintone Backup Tool - Tài liệu API

---

## 1. Sử dụng API nào?

### Get Records API

**API:** `GET /k/v1/records.json`

API này cho phép lấy nhiều records từ một app bằng cách chỉ định App ID và query string.

**Thông tin cơ bản:**

- **Method:** `GET`
- **URL:** `https://{subdomain}.kintone.com/k/v1/records.json`
- **Authentication:** API Token hoặc Basic Authentication ( vào app settings để tạo API Token )

**Parameters:**

- `app` (bắt buộc): ID của ứng dụng
- `query` (tùy chọn): Query string để lọc records (ví dụ: `Created_datetime = TODAY()`)
- `fields` (tùy chọn): Mảng các field code cần lấy. **Nếu không chỉ định, tất cả các field có thể truy cập sẽ được trả về**
- `totalCount` (tùy chọn): Nếu `true`, trả về tổng số records khớp với query

**Tài liệu tham khảo:** [Get Records API](https://kintone.dev/en/docs/kintone/rest-api/records/get-records/)

---

## 2. Có thể get all field của app được không?

### Có, có 2 cách:

#### Cách 1: Sử dụng Get Records API (không chỉ định fields)

Khi gọi Get Records API mà **không chỉ định parameter `fields`**, API sẽ tự động trả về tất cả các field có thể truy cập trong app.

#### Cách 2: Sử dụng Get Form Fields API

**API:** `GET /k/v1/app/form/fields.json`

API này trả về danh sách tất cả các field và cấu hình của chúng trong một app.

**Thông tin cơ bản:**

- **Method:** `GET`
- **URL:** `https://{subdomain}.kintone.com/k/v1/app/form/fields.json`
- **Authentication:** Basic Authentication (không hỗ trợ API Token)
- **Parameter:** `app` (bắt buộc): ID của ứng dụng

**Lưu ý:**

- Cần có quyền xem hoặc thêm records trong app
- Không hỗ trợ API Token, chỉ hoạt động với Basic Authentication

**Tài liệu tham khảo:** [Get Form Fields API](https://kintone.dev/en/docs/kintone/rest-api/apps/form/get-form-fields/)

---

## 3. Download File API

### Download File API

**API:** `GET /k/v1/file.json`

API này cho phép download files từ attachment field trong một App.

**Thông tin cơ bản:**

- **Method:** `GET`
- **URL:** `https://{subdomain}.kintone.com/k/v1/file.json`
- **Authentication:** API Token, Password Authentication, hoặc Session Authentication
- **Content-Type:** `application/json` (không cần nếu dùng query string)

**Parameters:**

- `fileKey` (bắt buộc): File key của attachment file. File key này cần được lấy từ response của Get Record API hoặc Get Records API.

**Lưu ý quan trọng:**

- File key từ Download File API **khác** với file key từ Upload File API
- File key được lấy từ response của Get Record/Get Records API trong field type `FILE`

**Permissions cần thiết:**

- App view permissions cho App liên quan
- Record view permissions cho record liên quan
- Field view permissions cho field liên quan

**Ví dụ Request:**

```bash
# Query String
curl -X GET 'https://{subdomain}.kintone.com/k/v1/file.json?fileKey=20150417022053715283FF97DC413CBC4B7A41C' \
  -H 'X-Cybozu-API-Token: YOUR_API_TOKEN' \
  -o ./downloaded_file.pdf

# JSON Body
curl -X GET 'https://{subdomain}.kintone.com/k/v1/file.json' \
  -H 'X-Cybozu-API-Token: YOUR_API_TOKEN' \
  -H 'Content-Type: application/json' \
  -d '{
    "fileKey": "20150417022053715283FF97DC413CBC4B7A41C"
  }'
```

**Ví dụ Response:**

Response trả về file content với MIME media type được chỉ định trong `Content-Type` header.

**Cách lấy fileKey:**

File key được lấy từ response của Get Record API hoặc Get Records API. Ví dụ:

```json
{
  "record": {
    "file": {
      "type": "FILE",
      "value": [
        {
          "contentType": "text/plain",
          "fileKey": "20150417022053715283FF97DC413CBC4B7A41C",
          "name": "kintoneUpdates.txt",
          "size": "25302"
        },
        {
          "contentType": "text/plain",
          "fileKey": "20150417022159ECFC1223C4B34C939E1B9BD25",
          "name": "APIUpdatestxt",
          "size": "20311"
        }
      ]
    }
  }
}
```

**Limitations:**

- API này không thể được gọi thông qua Kintone REST API Request

**Tài liệu tham khảo:** [Download File API](https://kintone.dev/en/docs/kintone/rest-api/files/download-file/)

---

## 4. Giới hạn request của API như thế nào?

### 4.1. Giới hạn số lượng records

| Giới hạn                      | Giá trị     | Mô tả                                                     |
| ----------------------------- | ----------- | --------------------------------------------------------- |
| **Records mỗi request**       | 500 records | Số lượng records tối đa có thể lấy trong một request      |
| **Offset tối đa**             | 10,000      | Giá trị `offset` tối đa có thể sử dụng                    |
| **Fields trong query string** | 0-99        | Chỉ số mảng `fields` trong query string                   |
| **Fields trong request body** | 1,000       | Số lượng fields tối đa có thể chỉ định trong request body |

### 4.2. Giới hạn request đồng thời (Concurrent Requests)

| Giới hạn              | Giá trị                             |
| --------------------- | ----------------------------------- |
| **Request đồng thời** | **100 requests**                    |
| **Khi vượt quá**      | Trả về HTTP 429 (Too Many Requests) |

**Lưu ý:** Giới hạn này áp dụng cho toàn bộ domain/subdomain Kintone.

### 4.3. Giới hạn request theo ngày (Daily API Requests)

| Giới hạn             | Giá trị                                     |
| -------------------- | ------------------------------------------- |
| **Request mỗi ngày** | **10,000 requests/app**                     |
| **Thời gian reset**  | 9:00 AM JST (Japan Standard Time) hàng ngày |
| **Khi vượt quá**     | API sẽ bị từ chối cho đến khi reset         |

**Lưu ý:**

- Giới hạn này áp dụng cho mỗi app riêng biệt
- Một số API không tính vào giới hạn này (ví dụ: API không yêu cầu App ID cụ thể)

### 4.4. Giới hạn khác

| Loại                | Giới hạn        | Mô tả                                                                                           |
| ------------------- | --------------- | ----------------------------------------------------------------------------------------------- |
| **Keyword search**  | 100,000 records | Khi dùng `like` hoặc `not like`, nếu số records chứa keyword vượt quá 100,000, search sẽ bị hủy |
| **Bulk operations** | 100 records     | Số lượng records tối đa có thể thêm/cập nhật/xóa trong một request                              |

**Tài liệu tham khảo:**

- [Kintone REST API Overview - Limitations](https://kintone.dev/en/docs/kintone/rest-api/overview/kintone-rest-api-overview/)

---

## 📚 Tài liệu tham khảo

- [Get Records API](https://kintone.dev/en/docs/kintone/rest-api/records/get-records/)
- [Get Form Fields API](https://kintone.dev/en/docs/kintone/rest-api/apps/form/get-form-fields/)
- [Download File API](https://kintone.dev/en/docs/kintone/rest-api/files/download-file/)
- [Kintone REST API Overview](https://kintone.dev/en/docs/kintone/rest-api/overview/kintone-rest-api-overview/)
