# Kintone Backup System - System Design

Tài liệu thiết kế hệ thống backup dữ liệu từ Kintone với scheduling, queue processing và S3 storage.

---

## 1. System Architecture Overview

### 1.1. High-Level Architecture

Xem chi tiết diagram trong [SYSTEM_DESIGN_DIAGRAMS.md](./SYSTEM_DESIGN_DIAGRAMS.md#11-high-level-architecture).

### 1.2. Multi-App Concurrent

Xem chi tiết diagram trong [SYSTEM_DESIGN_DIAGRAMS.md](./SYSTEM_DESIGN_DIAGRAMS.md#22-multi-app-concurrent-backup-flow).

### 1.3. Component Breakdown

| Component          | Technology                     | Responsibility                                   |
| ------------------ | ------------------------------ | ------------------------------------------------ |
| **Frontend**       | Inertia.js + React             | Admin dashboard, app management, scheduling UI   |
| **Backend API**    | Laravel                        | REST API, authentication, business logic         |
| **Scheduler**      | Laravel Scheduler + Database   | Schedule backup jobs, trigger at specified times |
| **Queue System**   | Laravel Queue (Database) / SQS | Queue backup jobs, handle concurrency            |
| **Workers**        | Laravel Queue Workers          | Process backup jobs, call Kintone API            |
| **Storage**        | PostgreSQL/MySQL               | Store app configs, API tokens, backup logs       |
| **Temp Storage**   | Local Filesystem               | Temporary file storage before S3 upload          |
| **Object Storage** | AWS S3                         | Store CSV files and attachments                  |

#### Chi tiết các Component quan trọng:

**Queue System:**

- **Laravel Queue với Database**: Lưu trữ các backup jobs trong queue, đảm bảo jobs được xử lý tuần tự hoặc song song theo cấu hình
- **AWS SQS (Optional)**: Dùng khi cần scale lớn hoặc multi-server deployment
- **Chức năng**: Nhận jobs từ Scheduler, quản lý thứ tự xử lý, đảm bảo không mất jobs khi server restart

**Workers:**

- **Laravel Queue Workers**: Các process chạy background để xử lý jobs từ queue
- **Chức năng**:
  - Lấy jobs từ queue
  - Gọi Kintone API để fetch records và download files
  - Xử lý dữ liệu (generate CSV, organize files)
  - Upload lên S3
  - Update status vào database
- **Scaling**: Có thể chạy nhiều workers song song (tối đa 100 theo Kintone limit)

**Storage - PostgreSQL/MySQL:**

- **Mục đích**: Lưu trữ **metadata và configuration**, KHÔNG lưu dữ liệu backup thực tế
- **Dữ liệu lưu trữ**:
  - **App configs**: Thông tin Kintone apps (subdomain, app_id, api_token)
  - **API tokens**: Tokens đã được encrypt để authenticate với Kintone ( hiện tại chưa biết nên lưu ở đâu nên lưu tạm vào database và API token hiện tại ko có expire time )
  - **Backup logs**: Lịch sử backup jobs, status, error messages ( vì nhiều lí do nên implement log table càng sớm càng tốt )
  - **Schedules**: Thời gian backup cho từng app
  - **User accounts**: Admin accounts
- **Khác biệt với Temp Storage & Object Storage**:
  - **Storage (DB)**: Chỉ metadata, nhỏ gọn, query nhanh
  - **Temp Storage**: Files tạm thời trên server trước khi upload S3
  - **Object Storage (S3)**: Dữ liệu backup thực tế (CSV + files), lưu trữ lâu dài

---

## 2. Backup Flow Diagram

Xem các backup flow diagrams trong [SYSTEM_DESIGN_DIAGRAMS.md](./SYSTEM_DESIGN_DIAGRAMS.md#2-backup-flow-diagrams):

- [2.1. Complete Backup Flow](./SYSTEM_DESIGN_DIAGRAMS.md#21-complete-backup-flow)
- [2.2. Failure Flow - Fetch Records với Retry Logic](./SYSTEM_DESIGN_DIAGRAMS.md#22-failure-flow---fetch-records-với-retry-logic)
- [2.3. Download Files & Zip Flow - Success & Failure](./SYSTEM_DESIGN_DIAGRAMS.md#23-download-files--zip-flow---success--failure)
- [2.4. Upload to S3 Flow - Success & Failure](./SYSTEM_DESIGN_DIAGRAMS.md#24-upload-to-s3-flow---success--failure)

---

## 3. Database Schema

Xem chi tiết database schema trong [DATABASE_SCHEMA.md](./DATABASE_SCHEMA.md).

---

## 4. Tech Stack Recommendations

### 4.1. Core Stack ( Tham khảo chứ muốn làm gì làm )

| Layer                 | Technology | Purpose                         |
| --------------------- | ---------- | ------------------------------- |
| **Backend Framework** | Laravel    | Main application framework      |
| **Frontend**          | Inertia.js | Connect Laravel with React      |
| **Frontend UI**       | React      | UI components                   |
| **Database**          | MySQL      | MySQL                           |
| **Queue Driver**      | Database   | Queue backend (Laravel default) |
| **Object Storage**    | AWS S3     | Store CSV and files             |
| **File System**       | Local      | Temporary file storage          |

**Lưu ý:** PHP ZipArchive extension (built-in) được dùng để zip files, không cần package thêm.

### 4.3. Queue Strategy

#### Option 1: Laravel Queue với Database (Default - Recommended)

**Ưu điểm:**

- ✅ **Không cần Redis** - Dùng database hiện có (PostgreSQL/MySQL)
- ✅ Đơn giản nhất, không cần setup thêm service
- ✅ Tích hợp sẵn với Laravel (default driver)
- ✅ Phù hợp cho small-medium scale (< 10 apps concurrent)
- ✅ Retry mechanism có sẵn
- ✅ Dễ debug (xem jobs trực tiếp trong database)

**Nhược điểm:**

- ❌ **Chậm hơn Redis** - Polling database mỗi vài giây
- ❌ **Không có job prioritization** tốt
- ❌ **Database load cao** khi có nhiều workers polling
- ❌ **Không phù hợp cho high concurrency** (> 20 workers)

**Khi nào dùng Database Queue:**

- ✅ Small-medium scale: < 10 apps backup cùng lúc
- ✅ Không muốn setup Redis
- ✅ Budget hạn chế
- ✅ Development/testing environment
- ✅ Production với số lượng apps vừa phải

---

#### Option 2: AWS SQS (Optional - Cho scale lớn hoặc multi-server)

**Ưu điểm:**

- ✅ Fully managed, không cần maintain
- ✅ Auto-scaling workers
- ✅ High availability
- ✅ Dead letter queue tự động
- ✅ Phù hợp cho multi-server deployment

**Nhược điểm:**

- ❌ Phức tạp hơn (cần AWS setup)
- ❌ Chi phí (nhưng rẻ)
- ❌ Latency cao hơn một chút

**Khi nào dùng SQS:**

- Có > 10 apps backup cùng lúc thường xuyên
- Multi-server deployment
- Cần high availability
- Có budget cho AWS services
- Lưu ý nếu xài với Laravel thì delay time tối đa là 15 phút

#### Recommendation

**Cho yêu cầu hiện tại (tối đa 10 apps concurrent):**

**Scenario 1: Small-medium scale (< 10 apps concurrent) - RECOMMENDED**
→ **Sử dụng Database Queue** (Laravel default)

**Lý do:**

- Không cần setup Redis
- Đơn giản nhất, dùng database hiện có
- Đủ cho < 10 apps concurrent
- Dễ maintain và debug

**Scenario 2: Large scale (> 10 apps concurrent)**
→ **Sử dụng AWS SQS**

**Lý do:**

- Auto-scaling
- Multi-server deployment
- High availability

---

## 6. File Storage Strategy

### 6.1. Temp Storage Structure

**Trước khi zip:**

```
/temp-2025-01-15/
├── app-123/
│   ├── data.csv
│   ├── fileKey1_document.pdf
│   ├── fileKey2_image.jpg
│   ├── fileKey3_data.xlsx
│   └── ... (tất cả files trong cùng folder với CSV)
├── app-456/
│   ├── data.csv
│   ├── fileKey1_file.pdf
│   └── ...
└── ...
```

**Sau khi zip:**

```
/temp-2025-01-15/
├── app-123/
│   └── backup.zip (chứa: data.csv + tất cả files)
├── app-456/
│   └── backup.zip
└── ...
```

**Lưu ý:** CSV và files được lưu trong cùng folder, sau đó zip lại thành 1 file `backup.zip`.

### 6.2. S3 Structure

```
s3://bucket-name/
└── 2025-01-15/
    ├── app-123/
    │   ├── backup.zip (chứa: data.csv + tất cả files)
    │   └── metadata.json (optional)
    ├── app-456/
    │   ├── backup.zip
    │   └── metadata.json
    └── ...
```

**Lưu ý:** Mỗi app chỉ có 1 file `backup.zip` chứa CSV và tất cả files, giúp giảm số lượng S3 requests và dễ quản lý.

---

## 7. Error Handling & Monitoring

### 7.1. Error Handling

- **Retry Logic:** 3 retries với exponential backoff
- **Dead Letter Queue:** Failed jobs sau 3 retries ( cần confirm )
- **Logging:** Chi tiết trong `backup_logs` table

### 7.2. Monitoring

- **API Request Tracking:** Monitor daily limits trong `api_request_logs` table
- **Alerts:** Không cần thiết alert nhưng cần check daily limit trước khi excute hàm backup
- **Database Jobs Table:** Monitor jobs trực tiếp trong database nếu xài default queue từ laravel

---

## 8. Security Considerations

### 8.1. API Token Storage

- **Encryption:** Encrypt API tokens trong database
- **Access Control:** Chỉ admin có thể xem/edit tokens
- **Audit Log:** Log mọi thay đổi tokens

### 8.2. S3 Access

- **IAM Roles:** Use IAM roles thay vì access keys khi có thể
- **Bucket Policy:** Restrict access chỉ từ application
- **Encryption:** Enable S3 server-side encryption

---

## 9. Deployment Recommendations

### 9.1. Server Requirements ( chỉ tham khảo vì chưa biết thực tế bao nhiêu app và bao nhiêu records cho từng app)

- **CPU:** 4+ cores (cho workers)
- **RAM:** 8GB+ (cho queue processing)
- **Storage:** 100GB+ (cho temp files)
- **Network:** Good bandwidth (cho download/upload files)

### 9.2. Worker Deployment

- **Supervisor:** Dùng Supervisor để manage workers
- **Monitoring:** Monitor workers qua database jobs table
- **Auto-restart:** Configure auto-restart khi workers crash
