sequenceDiagram
participant Shop as Shop Device
participant API as FastAPI Server
participant GiftService
participant SupplierService
participant GiftRepo as GiftRepository
participant SupplierRepo as SupplierRepository
participant AccountRepo as SupplierAccountRepository
participant DB as Database

    Shop->>API: POST /api/gifts/use<br/>{gift_id, supplier_invoice_no, pin}
    API->>GiftService: use_gift(gift_id, supplier_invoice_no, pin)

    Note over GiftService: Step 1: Verify Gift
    GiftService->>GiftService: verify_gift_by_id(gift_id)
    GiftService->>GiftRepo: get_by_gift_id(gift_id)
    GiftRepo->>DB: SELECT * FROM gift_codes WHERE gift_id = ?
    DB-->>GiftRepo: Gift data
    GiftRepo-->>GiftService: Gift object
    GiftService->>GiftService: Validate gift (status, dates)

    alt Gift invalid
        GiftService-->>API: (False, gift_error, ...)
        API-->>Shop: 400 Bad Request
    else Gift valid
        Note over GiftService: Step 2: Verify Supplier Invoice
        GiftService->>SupplierService: verify_supplier_invoice_no(invoice_no)
        SupplierService->>SupplierRepo: get_by_invoice_no(invoice_no)
        SupplierRepo->>DB: SELECT * FROM suppliers<br/>WHERE supplier_invoice_no = ?
        DB-->>SupplierRepo: Supplier data (or null)

        alt Supplier not found in suppliers table
            SupplierService->>AccountRepo: get_by_invoice_no(invoice_no)
            AccountRepo->>DB: SELECT * FROM supplier_accounts<br/>WHERE supplier_account_invoice_no = ?
            DB-->>AccountRepo: SupplierAccount (or null)

            alt SupplierAccount found
                SupplierService->>SupplierRepo: get_by_supplier_code(supplier_code)
                SupplierRepo->>DB: SELECT * FROM suppliers WHERE supplier_code = ?
                DB-->>SupplierRepo: Supplier data
            end
        end

        alt Supplier invoice invalid
            SupplierService-->>GiftService: (False, "Supplier invoice not found", ...)
            GiftService-->>API: (False, supplier_error, ...)
            API-->>Shop: 400 Bad Request
        else Supplier invoice valid
            Note over GiftService: Step 3: Verify PIN
            GiftService->>AccountRepo: get_by_supplier_code_and_pin(supplier_code, pin)
            AccountRepo->>DB: SELECT * FROM supplier_accounts<br/>WHERE supplier_code = ?<br/>AND supplier_account_secret_code = ?
            DB-->>AccountRepo: SupplierAccount (or null)

            alt PIN invalid
                AccountRepo-->>GiftService: None
                GiftService-->>API: (False, "Invalid PIN", ...)
                API-->>Shop: 400 Bad Request
            else PIN valid
                Note over GiftService: Step 4: Update Gift to Used
                GiftService->>GiftService: Update gift status to USED<br/>Set gift_used_datetime = now()
                GiftService->>GiftRepo: update(gift)
                GiftRepo->>DB: UPDATE gift_codes<br/>SET gift_status = 1,<br/>gift_used_datetime = NOW()<br/>WHERE gift_id = ?
                DB-->>GiftRepo: Success
                GiftRepo-->>GiftService: Updated Gift
                GiftService-->>API: (True, "Gift used successfully", ...)
                API-->>Shop: 200 OK + GiftUseResponse
            end
        end
    end
