sequenceDiagram
    participant Client
    participant API as FastAPI Server
    participant GiftService
    participant GiftRepository
    participant DB as Database

    Client->>API: GET /api/gifts/verify/{gift_id}
    API->>GiftService: verify_gift_by_id(gift_id)
    GiftService->>GiftRepository: get_by_gift_id(gift_id)
    GiftRepository->>DB: SELECT * FROM gift_codes WHERE gift_id = ?
    DB-->>GiftRepository: Gift data
    GiftRepository-->>GiftService: Gift object

    alt Gift not found
        GiftService-->>API: (False, "Gift code not found", ...)
        API-->>Client: 400 Bad Request
    else Gift already used
        GiftService-->>API: (False, "Gift code already used", ...)
        API-->>Client: 400 Bad Request
    else Gift not valid yet
        GiftService-->>API: (False, "Gift code not valid yet", ...)
        API-->>Client: 400 Bad Request
    else Gift expired
        GiftService-->>API: (False, "Gift code expired", ...)
        API-->>Client: 400 Bad Request
    else Gift is valid
        GiftService-->>API: (True, "Gift code is valid", ...)
        API-->>Client: 200 OK + GiftResponse
    end